/*:ja
 * @plugindesc 戦闘中立ち絵アニメ表示プラグイン
 * @author TRS
 * @help アニメ用の各ピクチャの命名規則は'ファイル名' + _01～_90となります
 *
 * @param -------基本設定-----
 * @desc セパレータ
 *
 * @param アニメ用ピクチャ番号
 * @desc 戦闘立ち絵グラのピクチャNO
 * @type number
 * @min 1
 * @max 100
 * @default 1
 *
 * @param アニメ先行用ピクチャ番号
 * @desc 先行ロード用ピクチャ番号
 * @type number
 * @min 1
 * @max 100
 * @default 10
 *
 * @param 横座標
 * @desc 戦闘立ち絵アニメを表示するX座標
 * @type number
 * @min -816
 * @max 816
 * @default 0
 *
 * @param 縦座標
 * @desc 戦闘立ち絵アニメを表示するY座標
 * @type number
 * @min -624
 * @max 624
 * @default 0
 
 * @param アマブレHPの割合
 * @desc アマブレするHPの割合(0～100)
 * @default 70
 * @type number
 * @min 0
 * @max 100
 *
 * @param 捕まるステート
 * @desc 振りほどくが出るステータス異常
 * @type state
 * @default 26
 *
 * @param 振りほどくコマンド名
 * @desc 捕まった時に攻撃の代わりに出すコマンド名
 * @default 振りほどく
 *
 * @param なすがままコマンド名
 * @desc 捕まった時何もしないコマンド
 * ・空文字を設定するとこの機能は省略されます
 * @default なすがまま
 *
 * @param 挑発コマンド名
 * @desc 強制的に敵を捕まえに来させるコマンド名
 * ・空文字を設定するとこの機能は省略されます
 * ・ツクールからコマンドタイプ追加で行うと入力ステップが多くなるためここで設定します
 * @default 挑発
 *
 * @param 挑発時実行コモンイベント
 * @desc 挑発時に実行されるコモンイベント
 * @type common_event
 * @default 208
 *
 * @param ---待機アニメの設定---
 * @desc セパレータ
 *
 * @param 通常立ち絵名
 * @desc 通常立ち絵ピクチャ名
 *
 * @param アマブレ立ち絵名
 * @desc アマブレ立ち絵ピクチャ名
 
 * @param 立ち絵アニメ枚数
 * @desc 立ち絵アニメーション枚数
 * @type number
 * @min 1
 * @max 60
 * @default 15
 
 * @param 立ち絵アニメウェイト
 * @desc 立ち絵アニメーション1枚のウェイト数
 * @type number
 * @min 4
 * @max 100
 * @default 15
 *
 * @param ---ダメージアニメの設定---
 * @desc セパレータ
 *
 * @param 通常ダメージ絵名
 * @desc 通常ダメージピクチャ名
 *
 * @param アマブレダメージ絵名
 * @desc アマブレダメージピクチャ名
 *
 * @param ダメージ絵アニメ枚数
 * @desc ダメージアニメーション枚数
 * @type number
 * @min 1
 * @max 60
 * @default 15
 *
 * @param ダメージ絵アニメウェイト
 * @desc ダメージアニメーション1枚のウェイト数
 * @type number
 * @min 4
 * @max 100
 * @default 15
 *
 * @param ---勝利アニメの設定---
 * @desc セパレータ
 *
 * @param 通常勝利絵名
 * @desc 通常勝利ピクチャ名
 *
 * @param アマブレ勝利絵名
 * @desc アマブレ勝利ピクチャ名
 *
 * @param 勝利絵アニメ枚数
 * @desc 勝利アニメーション枚数
 * @type number
 * @min 1
 * @max 60
 * @default 15
 *
 * @param 勝利絵アニメウェイト
 * @desc 勝利アニメーション1枚のウェイト数
 * @type number
 * @min 4
 * @max 100
 * @default 15
 *
 * @param ---拘束時の設定----
 * @desc セパレータ
 * 
 * @param レバガチャ時の立ちアニメ揺れ具合
 * @desc レバガチャ１回で立ちアニメ揺れる大きさ
 * @type number
 * @min 0
 * @max 50
 * @default 25
 *
 * @param --ランダムアニメの設定--
 * @desc セパレータ
 *
 * @param ランダムアニメファイル指定
 * @desc ランダムで使う個別基本ファイル名（コンマ区切りで複数設定）
 * @default ランダム
 *
 * @param AB用ランダムアニメファイル指定
 * @desc アマブレ時、ランダムで使う個別基本ファイル名（コンマ区切りで複数設定）
 * @default ABランダム
 *
 * @param 拘束アニメウェイト
 * @desc 拘束アニメの各ウェイト数
 * @min 4
 * @max 100
 * @default 5
 *
 * @param 拘束アニメ枚数
 * @desc 拘束アニメーション枚数
 * @min 1
 * @max 60
 * @default 15
 *
 * @param --音に関する設定---
 * @desc セパレータ
 * 
 * @param 音声ファイル視聴
 * @desc ※ここは確認だけの機能のため、反映されません
 * @type file
 * @require 1
 * @dir audio/se
 *
 * @param 声音量
 * @desc 声の音量(今回は、BGSもこの音量になります)
 * @type number
 * @min 0
 * @max 300
 * @default 90
 *
 * @param 声ピッチ
 * @desc 声のピッチ(今回は、BGSもこのピッチになります)
 * @type number
 * @min 1
 * @max 300
 * @default 100
 *
 *
 * @param 戦闘開始時声
 * @desc 戦闘開始時に再生される声(コンマ区切りで複数設定)
 * @default v1,v2 
 *
 * @param アマブレ戦闘開始時声
 * @desc アマブレ状態で戦闘開始時に再生される声
 *(コンマ区切りで複数設定)
 * @default v1,v2 
 *
 * @param 戦闘勝利声
 * @desc 戦闘勝利時に再生される声
 * (コンマ区切りで複数設定)
 * @default v1,v2 
 *
 * @param アマブレ戦闘勝利声
 * @desc アマブレ状態で戦闘勝利時に再生される声
 *(コンマ区切りで複数設定)
 * @default v1,v2 
 *
 * @param 攻撃声
 * @desc 攻撃時に再生される声
 * (コンマ区切りで複数設定)
 * @default attack1,attack2
 *
 * @param ダメージ声
 * @desc ダメージを受けた時に再生される声
 * (コンマ区切りで複数設定)
 * @default damage3,damage4
 *
 * @param 通常拘束時BGS
 * @desc 拘束時に再生されるBGS
 *（番号:n BGS:abc:を1ワードとしてコンマ区切り）
 * @default 番号:1 BGS:ずちゃ1,番号:2 BGS:ずちゃ2
 *
 * @param 通常拘束時の音
 * @desc 拘束時に再生されるループSE
 *（番号:n 枚目:n 効果音:abcを1ワードとしてコンマ区切り）
 * @default 番号:1 枚目:1 効果音:blow1,番号:2 枚目:1 効果音:blow2
 * 
 * @param 通常拘束時の声
 * @desc 拘束時に再生されるループ声
 *（番号:n 枚目:n 声:abcを1ワードとしてコンマ区切り）
 * @default 番号:1 枚目:1 声:C6,番号:2 枚目:1 声:C8
 *
 * @param アマブレ拘束時BGS
 * @desc 拘束時に再生されるBGS
 *（番号:n BGS:abc:を1ワードとしてコンマ区切り）
 * @default 番号:1 BGS:ずちゃ1,番号:2 BGS:ずちゃ2
 *
 * @param アマブレ拘束時の音
 * @desc 拘束時に再生されるループSE
 *（番号:n 枚目:n 効果音:abcを1ワードとしてコンマ区切り）
 * @default 番号:1 枚目:1 効果音:blow1,番号:2 枚目:1 効果音:blow2
 * 
 * @param アマブレ拘束時の声
 * @desc 拘束時に再生されるループ声
 *（番号:n 枚目:n 声:abcを1ワードとしてコンマ区切り）
 * @default 番号:1 枚目:1 声:C6,番号:2 枚目:1 声:C8
 *
 *
 *
*/

(function() {
	
	var parameters = PluginManager.parameters('BattleStandAnime');
	//---基本設定の値代入----
	var picNo = Number(parameters['アニメ用ピクチャ番号'] || 1);
	var priLoadNo = Number(parameters['アニメ先行用ピクチャ番号'] || 10);
	var picXpos = Number(parameters['横座標'] || 0);
	var picYpos = Number(parameters['縦座標'] || 0);
	var varAmaBre = Number(parameters['アマブレHPの割合'] || 70);
	var varBressIndex = 0;
	var varBressAnimeCnt = 0;
	var sexhraState = Number( parameters['捕まるステート'] || 26 )
	var furihodoku = parameters['振りほどくコマンド名'] || '振りほどく';
	var nasugamama = parameters['なすがままコマンド名'] || 'なすがまま';
	var strTyouhatu = parameters['挑発コマンド名'];
	var tyouhatuCommon = Number( parameters['挑発時実行コモンイベント'] || 208 );
	
	//---待機アニメの設定---
	var strNormalStandPicName = parameters['通常立ち絵名'];						//通常立ち絵
	var strArmorBreaklStandPicName = parameters['アマブレ立ち絵名'];			//アマブレ立ち絵
	var intStandMaxNumber = Number( parameters['立ち絵アニメ枚数'] || 15 );		//アニメ枚数
	var intStandAnimeWait = Number( parameters['立ち絵アニメウェイト'] || 15 );	//一枚のウェイト数
	
	//---ダメージアニメの設定---
	var strNormalDamegePicName = parameters['通常ダメージ絵名'];						//通常ダメージ
	var strArmorBreakDamegePicName = parameters['アマブレダメージ絵名'];				//アマブレダメージ
	var intDamejiMaxNumber = Number( parameters['ダメージ絵アニメ枚数'] || 15 );		//アニメ枚数
	var intDamejiAnimeWait = Number( parameters['ダメージ絵アニメウェイト'] || 15 );	//一枚のウェイト数
	
	//---勝利アニメの設定---
	var strNormalWinPicName = parameters['通常勝利絵名'];
	var strArmorBreakWinPicName = parameters['アマブレ勝利絵名'];
	var intWinMaxNumber = Number( parameters['勝利絵アニメ枚数'] || 15 );		//アニメ枚数
	var intWinAnimeWait = Number( parameters['勝利絵アニメウェイト'] || 15 );	//一枚のウェイト数
	
	//---拘束時の設定----
	var intShakePos = Number( parameters['レバガチャ時の立ちアニメ揺れ具合'] || 25 );
	
	//---ランダムアニメの設定----
	var lstStrRandAnime = String( parameters['ランダムアニメファイル指定'] ).split(',');
	var lstStrABRandAnime = String( parameters['AB用ランダムアニメファイル指定'] ).split(',');
	var intRandAnimeWait = Number( parameters['拘束アニメウェイト'] || 5 );
	var intKouAnimeMax = Number( parameters['拘束アニメ枚数'] || 15 );
	
	//---ランダムアニメ中の効果音設定---
	var lstStrBgsSet = String( parameters['通常拘束時BGS'] ).split(',');
	var lstStrLoopSeSet = String( parameters['通常拘束時の音'] ).split(',');
	var lstStrLoopVoSet = String( parameters['通常拘束時の声'] ).split(',');
	
	var lstStrAbBgsSet = String( parameters['アマブレ拘束時BGS'] ).split(',');
	var lstStrAbLoopSeSet = String( parameters['アマブレ拘束時の音'] ).split(','); 
	var lstStrAbLoopVoSet = String( parameters['アマブレ拘束時の声'] ).split(','); 
	
	//---声の大きさとピッチ---
	var varVoiceVolume = Number( parameters['声音量'] || 90 );
	var varVoicePitch = Number ( parameters['声ピッチ'] || 100 );
	
	//---戦闘開始時の声取得
	var lstBattleStartVoice = String( parameters['戦闘開始時声'] ).split(',');
	var lstArmorBreakBattleStartVoice = String( parameters['アマブレ戦闘開始時声'] ).split(',');
	
	//---戦闘勝利時の声取得
	var lstBattleWinVoice = String( parameters['戦闘勝利声'] ).split(',');
	var lstArmorBreakBattleWinVoice = String( parameters['アマブレ戦闘勝利声'] ).split(',');
	
	//--戦闘時の掛け声・ダメージ声取得
	var lstAttackVoice = String( parameters['攻撃声'] ).split(',');
	var lstDamegeVoice = String( parameters['ダメージ声'] ).split(',');
	
	var varDamejiPlayer = false;					//プレイヤーダメージフラグ
	
	var intStandAnimeCnt = 0;						//立ち絵現在枚数カウント
	var intDamejiAnimeCnt = 0;						//ダメージ現在枚数カウント
	//-----------------------------------------------------------------------------
	// BattleManager　上書き
	//
	BattleManager.initMembers = function() 
	{
	    this._phase = 'init';
	    this._canEscape = false;
	    this._canLose = false;
	    this._battleTest = false;
	    this._eventCallback = null;
	    this._preemptive = false;
	    this._surprise = false;
	    this._actorIndex = -1;
	    this._actionForcedBattler = null;
	    this._mapBgm = null;
	    this._mapBgs = null;
	    this._actionBattlers = [];
	    this._subject = null;
	    this._action = null;
	    this._targets = [];
	    this._logWindow = null;
	    this._statusWindow = null;
	    this._spriteset = null;
	    this._escapeRatio = 0;
	    this._escaped = false;
	    this._rewards = {};
	    this._turnForced = false;
	    
	    this._picNo = picNo;					//他でとるためここに設定ピクチャ番号入れる
	    this._picXpos = picXpos;				//他でとるためここに設定X座標入れる
	    this._picYpos = picYpos;				//他でとるためここに設定Y座標入れる
	    
	    this._DamegeAnimeCnt = 0;
	    this._RestraintAnimeCnt = 0;			//拘束アニメカウント
	    this._RestraintAnimeIndex = 0;			//拘束アニメインデックス
		this._ShakePoint = 0;					//揺れる数値
		this._RestraintAnimeName = "";			//選ばれたファイル名の選択
		this._InputDelayCnt = 0;				//１度押されてからの間
		
	    this._index = 0;
	    this._nowPlayNo = 0;					//現在再生中の番号
	    
	    this._SeNo = [];						//ループ効果音
	    this._VoiceNo = [];						//ループ声
	    this._playBgs = [];		//Bgs
	    
	    this._abSeNo = [];						//ループ効果音
	    this._abVoiceNo = [];					//ループ声
	    this._abPlayBgs = [];		//Bgs
	    
	    this.loopSeSet();						//ループ再生ＳＥ
	    this.loopVoiceSet();					//声の設定
	    this.BgsSet();							//Bgsの設定
	    this._victoryFlg = false;				//勝利フラグ
	    
	    this._WinAnimeCnt = 0;					//勝利アニメカウンタ
	    this._WinAnimeIndex = 0;				//勝利アニメ再生インデックス
	};
	
	/*==============================================
		SE再生情報格納
	  ==============================================*/
	BattleManager.loopSeSet = function()
	{
		var lstInfo = [];
		var wrkNo = 0;
		var wrkFrame = 0;
		var wrkSeName = ''; 
		
		var i = 0;
		var j = 0;
		
		//初期化
		for(i = 0; i < lstStrRandAnime.length; i++)
		{
			this._SeNo[i] = [];
			
			for( j = 0; j < intKouAnimeMax; j++)
			{
				this._SeNo[i][j] = "";
				
			}
		}
		
		for(i = 0; i < lstStrABRandAnime.length; i++)
		{
			this._abSeNo[i] =[];
			for( j = 0; j < intKouAnimeMax; j++)
			{
				this._abSeNo[i][j] = "";
			}
		}
		
		//通常時のセクハラSE
		for(i = 0; i < lstStrLoopSeSet.length; i++ )
		{
			
			//一度配列
			var lstInfo = lstStrLoopSeSet[i].split(' ');
			
			if(lstInfo.length === 3 )
			{
				wrkNo = Number(lstInfo[0].replace('番号:','') ) - 1;
				wrkFrame = Number( lstInfo[1].replace('枚目:','') ) - 1;
				wrkSeName = lstInfo[2].replace('効果音:','');
					
				this._SeNo[wrkNo][wrkFrame] = wrkSeName;
			}
		}
		
		//アマブレ時のセクハラSe
		for(i = 0; i < lstStrAbLoopSeSet.length; i++ )
		{
			//一度配列
			var lstInfo = lstStrAbLoopSeSet[i].split(' ');
			
			if(lstInfo.length === 3)
			{
				wrkNo = Number(lstInfo[0].replace('番号:','') ) - 1;
				wrkFrame = Number( lstInfo[1].replace('枚目:','') ) - 1;
				wrkSeName = lstInfo[2].replace('効果音:','');

				this._abSeNo[wrkNo][wrkFrame] = wrkSeName;
			}
		}
		
	}
	
	/*==============================================
		声再生情報格納
	  ==============================================*/
	BattleManager.loopVoiceSet = function()
	{
		var lstInfo = [];
		var wrkNo = 0;
		var wrkFrame = 0;
		var wrkVoiceName = ''; 
		var i = 0;
		var j = 0;
		
		//初期化
		for(i = 0; i < lstStrRandAnime.length; i++)
		{
			this._VoiceNo[i] = [];
			for( j = 0; j < intKouAnimeMax; j++)
			{
				this._VoiceNo[i][j] = "";
			}
		}
		
		//AB用初期化
		for(i = 0; i < lstStrABRandAnime.length; i++)
		{
			this._abVoiceNo[i] =[];
			for( j = 0; j < intKouAnimeMax; j++)
			{
				this._abVoiceNo[i][j] = "";
			}
		}
		
		//通常時のセクハラ声
		for(i = 0; i < lstStrLoopVoSet.length; i++ )
		{
			//一度配列
			var lstInfo = lstStrLoopVoSet[i].split(' ');
			
			if(lstInfo.length === 3)
			{
				wrkNo = Number(lstInfo[0].replace('番号:','') ) - 1;
				wrkFrame = Number( lstInfo[1].replace('枚目:','') ) - 1;
				wrkVoiceName = lstInfo[2].replace('声:','');
				
				this._VoiceNo[wrkNo][wrkFrame] = wrkVoiceName;
			}
		}
		
		//アマブレ時のセクハラ声
		for(i = 0; i < lstStrAbLoopVoSet.length; i++ )
		{
			//一度配列
			var lstInfo = lstStrAbLoopVoSet[i].split(' ');
			if(lstInfo.length === 3)
			{
				wrkNo = Number(lstInfo[0].replace('番号:','') ) - 1;
				wrkFrame = Number( lstInfo[1].replace('枚目:','') ) - 1;
				wrkVoiceName = lstInfo[2].replace('声:','');
			
				this._abVoiceNo[wrkNo][wrkFrame] = wrkVoiceName;
			}
		}
	}
	
	/*=============================================
	  			Bgs情報格納
	  =============================================*/
	BattleManager.BgsSet = function() 
	{
		var lstInfo = [];
		var wrkNo = 0;
		var wrkBgsName = ''; 
		
		var i = 0;
		
		//通常時のBgs
		for(i = 0; i < lstStrBgsSet.length; i++ )
		{
			//一度配列
			var lstInfo = lstStrBgsSet[i].split(' ');
			wrkNo = Number(lstInfo[0].replace('番号:','') ) - 1;
			wrkBgsName = lstInfo[1].replace('BGS:','');
			
			this._playBgs[wrkNo] = wrkBgsName;
			
		}
		
		//アマブレのBgs
		for(i = 0; i < lstStrAbBgsSet.length; i++ )
		{
			//一度配列
			var lstInfo = lstStrAbBgsSet[i].split(' ');
			
			if(lstInfo.length === 2)
			{
				wrkNo = Number(lstInfo[0].replace('番号:','') ) - 1;
				wrkBgsName = lstInfo[1].replace('BGS:','');
				
				this._abPlayBgs[wrkNo] = wrkBgsName;
			}
		}
	}
	
	
	/*==============================================
		敵が表れたメッセージの時点で立ち絵出す
	  ==============================================*/
	BattleManager.displayStartMessages = function() 
	{
		//this.PictureBressAnime();
		this.BattleStartVoice();
		
	    $gameTroop.enemyNames().forEach(function(name) {
	        $gameMessage.add(TextManager.emerge.format(name));
	    });
	    if (this._preemptive) 
	    {
	        $gameMessage.add(TextManager.preemptive.format($gameParty.name()));
	    }
	    else if (this._surprise) 
	    {
	        $gameMessage.add(TextManager.surprise.format($gameParty.name()));
	    }
	};
	
	/*======================================================
		BattleManager.updateを上書き
	  ======================================================*/
	BattleManager.update = function() 
	{
		//this.DamegeAnime();
		//this.PictureBressAnime();
		
	    if (!this.isBusy() && !this.updateEvent()) 
	    {
	        switch (this._phase) 
	        {
	        case 'start':
	            this.startInput();
	            break;
	        case 'turn':
	            this.updateTurn();
	            break;
	        case 'action':
	            this.updateAction();
	            break;
	        case 'turnEnd':
	            this.updateTurnEnd();
	            break;
	        case 'battleEnd':
	            this.updateBattleEnd();
	            break;
	        }
	    }
	};
	
	/*======================================================
		rpgManegerのBattleManager._BattleManager_updateActionを上書き
	  ======================================================*/
	BattleManager.updateAction = function() 
	{
	    var target = this._targets.shift();
	    
	    //this.PictureBressAnime();
	    //this.DamegeAnime();
	    
	    if (target) 
	    {
	        this.invokeAction(this._subject, target);
	       
	    } 
	    else 
	    {
	        this.endAction();
	        
	    }
	};
	
	/*=================================================
	  		息使いアニメ
	  =================================================*/
	BattleManager.PictureBressAnime = function()
	{
		//プレイヤーダメージ中でない時動く
		if(varDamejiPlayer === false)
		{
			//セクハラステートがついてない時に動く
			if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
			{
				varBressAnimeCnt += 1;
				
				//息継ぎアニメのピクチャ
				if( varBressAnimeCnt % intStandAnimeWait === 0)
				{
					var wrk = '';
					
					//アマブレ数値より大きいHpの時は通常絵
					if( !this.armorBreakInfo() )
						wrk = strNormalStandPicName;
					
					//少ないときはアマブレ絵
					else
						wrk = strArmorBreaklStandPicName;
					
					wrk += '_' + ('00' + (intStandAnimeCnt + 1) ).slice(-2);
					
					$gameScreen.showPicture(picNo, wrk, 0, picXpos, picYpos, 100, 100, 255, 0);	//編集したファイル名で表示
					//立ちアニメカウントが最大枚数より小さいときはカウント
					if(intStandAnimeCnt < intStandMaxNumber - 1)
					{
						intStandAnimeCnt++;
					}
					else
					{
						intStandAnimeCnt = 0;
						varBressAnimeCnt = 0;		//息継ぎアニメーションカウントもクリア
					}
				}
			}
		}
	}
	
	
	/*======================================================
		ダメージアニメ
	  ======================================================*/
	BattleManager.DamegeAnime = function() 
	{
		//プレイヤーダメージの時
		if(varDamejiPlayer === true)
		{
			//セクハラステートがついてない時に動く
			if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
			{
				this._DamegeAnimeCnt++;
				//ダメージアニメ
				if( this._DamegeAnimeCnt % intDamejiAnimeWait === 0 )
				{
					var wrk = '';

					//アマブレ数値より大きいHpの時は通常絵
					if( !this.armorBreakInfo() )
						wrk = strNormalDamegePicName;
					
					//少ないときはアマブレ絵
					else
						wrk = strArmorBreakDamegePicName;
					
					wrk += '_' + ('00' + (intDamejiAnimeCnt + 1) ).slice(-2);
					
					$gameScreen.showPicture(picNo, wrk, 0, picXpos, picYpos, 100, 100, 255, 0);	//編集したファイル名で表示

					//立ちアニメカウントが最大枚数より小さいときはカウント
					if(intDamejiAnimeCnt < intDamejiMaxNumber - 1)
					{
						intDamejiAnimeCnt++;
					}
					else
					{
						intDamejiAnimeCnt = 0;						//ダメージアニメ現番号クリア
						this._DamegeAnimeCnt = 0;					//クラスのカウンタ
						varDamejiPlayer = false;					//プレイヤーダメージフラグクリア
					}
				}
			}
		}
	}
	
	/*==========================================================
		拘束時のアニメ選択(スクリプトでエディタから呼び出します)
	  ==========================================================*/
	BattleManager.RestraintAnimeSelect = function()
	{
		
		var varWrkIndex = 0;
		this._nowPlayNo = 0;
		this._RestraintAnimeIndex = 0;
		
		//通常時
		if( this.armorBreakInfo() === false)
		{
			varWrkIndex = Math.floor( Math.random() * lstStrRandAnime.length );
			this._RestraintAnimeName = lstStrRandAnime[varWrkIndex];
			
			//Bgs再生判断
			if( this._playBgs[varWrkIndex] !== undefined)
			{
				AudioManager.playBgs({"name":this._playBgs[varWrkIndex],"volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
			}
			
		}
		
		//アマブレ時
		else
		{
			varWrkIndex = Math.floor( Math.random() * lstStrABRandAnime.length );
			this._RestraintAnimeName = lstStrABRandAnime[varWrkIndex];
			
			//Bgs再生判断
			if( this._abPlayBgs[varWrkIndex] !== undefined)
			{
				AudioManager.playBgs({"name":this._abPlayBgs[varWrkIndex],"volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
			}
			
		}
		
		this._nowPlayNo = varWrkIndex;								//現在進行値保持
	}
	
	/*======================================================
			拘束時のアニメ
	  ======================================================*/
	BattleManager.RestraintAnime = function() 
	{
		//セクハラステートの時動く
		if( $gameActors.actor(1).isStateAffected( sexhraState ) )
		{
			this._RestraintAnimeCnt+=1;
			if(this._RestraintAnimeCnt % intRandAnimeWait === 0)
			{
				var wrk = '';
				wrk = this._RestraintAnimeName;
				wrk += '_' + ('00' + ( this._RestraintAnimeIndex + 1 ) ).slice(-2);
				
				//立ちアニメカウントが最大枚数より小さいときはカウント
				if( this._RestraintAnimeIndex < intKouAnimeMax - 1)
				{
					this._RestraintAnimeIndex++;
				}
				else
				{
					this._RestraintAnimeIndex = 0;		//進行Indexクリア
					this._RestraintAnimeCnt = 0;		//セクハラアニメーションカウントもクリア
				}
				
				//通常時の効果音と声
				if( !this.armorBreakInfo() )
				{
					console.log("通常再生>" + this._nowPlayNo + " 通常実行>" + this._RestraintAnimeIndex);
					//console.log(this._SeNo[this._nowPlayNo][this._RestraintAnimeIndex]);
					
					//未設定時は効果音再生しない
					if( this._SeNo[this._nowPlayNo][this._RestraintAnimeIndex] !== '' ) 
					{
						AudioManager.playSe({"name":this._SeNo[this._nowPlayNo][this._RestraintAnimeIndex], "volume":90,"pitch":100,"pan":0});
					}
					
					//未設定時は声再生しない
					if( this._VoiceNo[this._nowPlayNo][this._RestraintAnimeIndex] !== '') 
					{
						AudioManager.playSe({"name":this._VoiceNo[this._nowPlayNo][this._RestraintAnimeIndex], "volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
					}
				}
				
				//アマブレ時の効果音と声
				else
				{
					//console.log("AB再生>" + this._nowPlayNo + " AB実行>" + this._RestraintAnimeIndex);
					//未設定時は効果音再生しない
					if( this._abSeNo[this._nowPlayNo][this._RestraintAnimeIndex] !== '' )
					{
						AudioManager.playSe({"name":this._abSeNo[this._nowPlayNo][this._RestraintAnimeIndex], "volume":90,"pitch":100,"pan":0});
					}
					
					//未設定時は声再生しない
					if( this._abVoiceNo[this._nowPlayNo][this._RestraintAnimeIndex] !== '' )
					{
						AudioManager.playSe({"name":this._abVoiceNo[this._nowPlayNo][this._RestraintAnimeIndex], "volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
					}
				}
				
				$gameScreen.showPicture(picNo, wrk, 0, picXpos + this._ShakePoint, picYpos, 100, 100, 255, 0);	//編集したファイル名で表示
			}
			
		}
	}
	
	/*======================================================
						入力時の揺れ
	  ======================================================*/
	BattleManager.RestraintInputShake = function()
	{
		//セクハラステートの時動く
		if( $gameActors.actor(1).isStateAffected( sexhraState ) )
		{
			if( Input.isTriggered('left') )
			{
				this._ShakePoint = -intShakePos;
				this._InputDelayCnt = 2;
			}
			else if( Input.isTriggered('right') )
			{
				this._ShakePoint = intShakePos;
				this._InputDelayCnt = 2;
			}
			
			//少したってからもどす
			if( this._InputDelayCnt > 0)
			{
				this._InputDelayCnt--;
			}
			else
			{
				this._InputDelayCnt = 0;
				this._ShakePoint = 0;
			}
			
			$gameScreen.movePicture(picNo, 0, picXpos + this._ShakePoint, picYpos, 100, 100, 255, 0, 1);	//編集したファイル名で表示
		}
	}
	/*======================================================
						先行ロード
	  ======================================================*/
	BattleManager.priLoadAnimePic = function() 
	{
	}
	
	/**
	 * アマブレ状態か判断する処理
	 */
	BattleManager.armorBreakInfo = function()
	{
		var ret = false;
		var fBreakChange = (varAmaBre / 100) * $gameActors.actor(1).mhp;
		
		//アマブレ中判断
		if( $gameActors.actor(1).hp < fBreakChange )
			ret = true;
			
		return ret;
	}
	
	/**
	 * 戦闘開始時声の再生
	 */
	BattleManager.BattleStartVoice = function()
	{
		var varWrkIndex = 0;
		var SelectVoiceFile = "";
		this._victoryFlg = false;
		//アマブレ度判断し再生ボイス変更
		if( !this.armorBreakInfo() )
		{
			varWrkIndex = Math.floor( Math.random() * lstBattleStartVoice.length );
			
			if(lstBattleStartVoice[varWrkIndex] !== undefined)
			{
				SelectVoiceFile = lstBattleStartVoice[varWrkIndex];
			}
			
		}
		
		//アマブレ
		else
		{
			varWrkIndex = Math.floor( Math.random() * lstArmorBreakBattleStartVoice.length );
			if(lstArmorBreakBattleStartVoice[varWrkIndex] !== undefined)
			{
				SelectVoiceFile = lstArmorBreakBattleStartVoice[varWrkIndex];
			}
		}
		
		AudioManager.playSe({"name":SelectVoiceFile,"volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
	}
	
	/**
	 * 勝利時のバトマネ
	 */
	BattleManager.processVictory = function() 
	{
	    $gameParty.removeBattleStates();
	    $gameParty.performVictory();
	    this.playVictoryMe();
	    this.playVictoryVoice();						//こいつを追加
	    this.replayBgmAndBgs();
	    this.makeRewards();
	    this.displayVictoryMessage();
	    this.displayRewards();
	    this.gainRewards();
	    this.endBattle(0);
	};
	
	/**
	 * 勝利ボイス
	 */
	 BattleManager.playVictoryVoice = function()
	 {
	 	var varWrkIndex = 0;
		var SelectVoiceFile = "";
		this._victoryFlg = true;
		
		//アマブレ度判断し再生ボイス変更
	 	if( !this.armorBreakInfo() )
	 	{
	 		varWrkIndex = Math.floor( Math.random() * lstBattleWinVoice.length );
	 		if(lstBattleWinVoice[varWrkIndex] !== undefined)
			{
				SelectVoiceFile = lstBattleWinVoice[varWrkIndex];
			}
	 		
	 	}
	 	else
	 	{
	 		varWrkIndex = Math.floor( Math.random() * lstArmorBreakBattleWinVoice.length );
	 		if(lstArmorBreakBattleWinVoice[varWrkIndex] !== undefined)
			{
				SelectVoiceFile = lstArmorBreakBattleWinVoice[varWrkIndex];
			}
	 	}
	 	
	 	AudioManager.stopSe();
	 	AudioManager.playSe({"name":SelectVoiceFile,"volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
	 }
	
	/**
	 * 振りほどくスキルID
	 */
	Game_BattlerBase.prototype.tyouhatuSkillId = function() 
	{
    	return 102;
	};
	
	/*=================================================
	  		勝利アニメ
	  =================================================*/
	BattleManager.victoryAnime = function()
	{
		
		 this._WinAnimeCnt += 1;
		
		//息継ぎアニメのピクチャ
		if( this._WinAnimeCnt % intWinAnimeWait === 0)
		{
			var wrk = '';
			
			//アマブレ数値より大きいHpの時は通常絵
			if( !this.armorBreakInfo() )
				wrk = strNormalWinPicName;
			
			//少ないときはアマブレ絵
			else
				wrk = strArmorBreakWinPicName;
			
			wrk += '_' + ('00' + (this._WinAnimeIndex + 1) ).slice(-2);
			
			$gameScreen.showPicture(picNo, wrk, 0, picXpos, picYpos, 100, 100, 255, 0);	//編集したファイル名で表示
			//立ちアニメカウントが最大枚数より小さいときはカウント
			if(this._WinAnimeIndex < intWinMaxNumber - 1)
			{
				this._WinAnimeIndex++;
			}
			else
			{
				this._WinAnimeCnt = 0;
				this._WinAnimeIndex = 0;		//アニメーションインデックスもクリア
			}
		}
		
	}
	
	/*======================================================
	 		 バトルログ上書き
	  ======================================================*/
	Window_BattleLog.prototype.displayHpDamage = function(target) 
	{
		isTokusyuMongon = false;
		
	    if (target.result().hpAffected) 
	    {
	        if (target.result().hpDamage > 0 && !target.result().drain) 
	        {
	            this.push('performDamage', target);
	            
	            //敵じゃない
	            if( target.isEnemy() === false)
	            {
	            	varDamejiPlayer = true;			//プレイヤーダメージフラグ
	            }
	            
	            //敵がターゲット
	            else
	            {
					var action = BattleManager._action;
					//データークラスがスキルの時
	    			if( action._item._dataClass === "skill" )
	    			{
	    				//アクションIDが1(攻撃)じゃない時
				    	if( action._item._itemId !== 1 )
				    	{
				    		isTokusyuMongon = true;
				    	}
	            	}
	            }
	        }
	        
	        if (target.result().hpDamage < 0) 
	        {
	            this.push('performRecovery', target);
	        }
	        
	        if(isTokusyuMongon === false)
	        {
	       		this.push('addText', this.makeHpDamageText(target) );
	       	}
	       	else
	       	{
	       		var result = target.result();
    			var damage = result.hpDamage;
	       		var wrkMessage = target.name() + 'に ' + damage + ' の快感を与えた！';
	       		this.push('addText', wrkMessage );
	       	}
		}
	};
	
	Window_BattleLog.prototype.displayAddedStates = function(target) 
	{
	    target.result().addedStateObjects().forEach(function(state) {
	        var stateMsg = target.isActor() ? state.message1 : state.message2;
	        if (state.id === target.deathStateId()) {
	            this.push('performCollapse', target);
	        }
	        
	        //条件付きで、イったにする
	        if(target.isActor() === false && state.id === target.deathStateId() )
	        {
	        	var action = BattleManager._action;
	        	if( action == BattleManager._action)
    			{
    				//アクションIDが1(攻撃)じゃない時
			    	if( action._item._itemId !== 1 && action._item._dataClass === "skill" )
			    	{
			    		stateMsg = 'はイってしまった！';
			    	}
            	}
	        }
	        
	        if (stateMsg) {
	            this.push('popBaseLine');
	            this.push('pushBaseLine');
	            console.log(stateMsg);
	            this.push('addText', target.name() + stateMsg);
	            this.push('waitForEffect');
	        }
	    }, this);
	};
	
	/**------------------------------------------------------
	 *  ハンドラ追加作成
	 */
	Scene_Battle.prototype.createActorCommandWindow = function() 
	{
	    this._actorCommandWindow = new Window_ActorCommand();
	    this._actorCommandWindow.setHandler('attack', this.commandAttack.bind(this));
	    this._actorCommandWindow.setHandler('skill', this.commandSkill.bind(this));
	    this._actorCommandWindow.setHandler('guard', this.commandGuard.bind(this));
	    this._actorCommandWindow.setHandler('item',  this.commandItem.bind(this));
	    
	    //挑発
	    if(strTyouhatu !== '')
	    	this._actorCommandWindow.setHandler('tyouhatu', this.commandTyouhatu.bind(this) );
	    
	    this._actorCommandWindow.setHandler('cancel', this.selectPreviousCommand.bind(this));
	    
	    this._actorCommandWindow.setHandler('fryAway', this.commandfryAway.bind(this) );
	    
	    //なすがまま未設定時はパス
	    if( nasugamama !== '')
	    	this._actorCommandWindow.setHandler('pass', this.commandPass.bind(this));

	    this.addWindow(this._actorCommandWindow);
	};
	
	/**
	 * バトル時
	 */
	Scene_Battle.prototype.start = function() 
	{
	    Scene_Base.prototype.start.call(this);
	    this.startFadeIn(this.fadeSpeed(), false);
	    BattleManager.playBattleBgm();
	    BattleManager.startBattle();
	    
	    BattleManager.priLoadAnimePic();
	};

	Scene_Battle.prototype.updateBattleProcess = function() 
	{
		if(BattleManager._victoryFlg === false)
		{
			BattleManager.PictureBressAnime();
			BattleManager.DamegeAnime();
			BattleManager.RestraintAnime();
			BattleManager.RestraintInputShake();
		}
		
		//勝利時
		else
		{
			BattleManager.victoryAnime();
		}
		
	    if (!this.isAnyInputWindowActive() || BattleManager.isAborting() ||
	            BattleManager.isBattleEnd()) {
	        BattleManager.update();
	        this.changeInputWindow();
	    }
	    
	};
	
	/**
	 * 振りほどく処理
	 */
	Scene_Battle.prototype.commandfryAway = function() 
	{
	    this.selectNextCommand();
    }
    
    /**
	 * なすがまま処理
	 */
	Scene_Battle.prototype.commandPass = function() 
	{
	    this.selectNextCommand();
    }
    
    /**
	 * 挑発処理
	 */
	Scene_Battle.prototype.commandTyouhatu = function() 
	{
		$gameTemp.reserveCommonEvent(tyouhatuCommon);
		BattleManager.inputtingAction().setTyouhatu();
	    this.selectNextCommand();
    }
    
    /**
     * 挑発処理
     */
    
    Game_Action.prototype.setTyouhatu = function() 
    {
    	//this.setSkill(this.subject().attackSkillId());
    	this.clear();							//アクション消す
	};

	/**------------------------------------------------------
	 *  コマンド作成
	 */
	Window_ActorCommand.prototype.makeCommandList = function() 
	{
    	if (this._actor) 
    	{
	    	//アクター1
	    	if( this._actor._actorId === 1 )
	    	{
	    		if( !$gameActors.actor(1).isStateAffected( sexhraState ) )
	    		{
		        	this.addAttackCommand();
		        	this.addSkillCommands();
		        	//this.addGuardCommand();
		        	this.addItemCommand();
		        	 if(strTyouhatu !== '')
						this.addTyouhatuCommand();
		        }
		        else
		        {
		        	//this.addFryAwayCommand();
		        	if( nasugamama !== '')
		        		this.addPassComand();
		        }
	        }
		}
    };
	
	/**
	 * 振りほどくコマンド作成
	 */
	Window_ActorCommand.prototype.addFryAwayCommand = function() 
	{
	    this.addCommand( furihodoku, 'fryAway');
	};
	
	/**
	 * なすがままコマンド作成
	 */
	Window_ActorCommand.prototype.addPassComand = function() 
	{
	    this.addCommand( nasugamama, 'pass');
	};
	
	/**
	 * 挑発コマンド作成
	 */
	Window_ActorCommand.prototype.addTyouhatuCommand = function() 
	{
	    this.addCommand( strTyouhatu, 'tyouhatu');
	};
	
	/*======================================================
			使用する絵の先行ロード
	  ======================================================*/
	function SenkouLoad( SenkouFileName )
	{
		$gameScreen.showPicture(priLoadNo, SenkouFileName, 0, 0, 0, 100, 100, 0, 0);
		
	}
	
	/**
	 * アクション判断
	 */
	var _Game_Actor_performAction = Game_Actor.prototype.performAction;
	Game_Actor.prototype.performAction = function(action) 
	{
		_Game_Actor_performAction.call(this, action);
		if (action.isAttack()) {
		  this.playAttackVoice();
		} 
		/*--未使用--*/
		//else if (action.isMagicSkill() && action.isHpRecover()) {
		//  SoundManager.playActorVoice(this.actor(), 'recover');
		//} else if (action.isMagicSkill() && action.isForFriend()) {
		//  SoundManager.playActorVoice(this.actor(), 'friendmagic');
		//} else if (action.isMagicSkill()) {
		//  SoundManager.playActorVoice(this.actor(), 'magic');
		//} else if (action.isSkill() && !action.isGuard()) {
		//  SoundManager.playActorVoice(this.actor(), 'skill');
		//}
		/*-----*/
	};
	
	/**
	 * アタックボイス選択、再生
	 */
	Game_Actor.prototype.playAttackVoice = function()
	{
		varWrkIndex = Math.floor( Math.random() * lstAttackVoice.length );
		var SelectVoiceFile = "";
		
		if(lstAttackVoice[varWrkIndex] !== undefined)
		{
			SelectVoiceFile = lstAttackVoice[varWrkIndex];
		}
		AudioManager.stopSe();
		AudioManager.playSe({"name":SelectVoiceFile,"volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
	}
	
	/**
	 * ダメージアクション
	 */
	var _Game_Actor_performDamage = Game_Actor.prototype.performDamage;
	Game_Actor.prototype.performDamage = function() 
	{
		_Game_Actor_performDamage.call(this);
		this.playDamegeVoice();
	};
	
	/**
	 * ダメージボイス再生
	 */
	Game_Actor.prototype.playDamegeVoice = function()
	{
		varWrkIndex = Math.floor( Math.random() * lstDamegeVoice.length );
		var SelectVoiceFile = "";
		
		if(lstDamegeVoice[varWrkIndex] !== undefined)
		{
			SelectVoiceFile = lstDamegeVoice[varWrkIndex];
		}
		AudioManager.stopSe();
		AudioManager.playSe({"name":SelectVoiceFile,"volume":varVoiceVolume,"pitch":varVoicePitch,"pan":0});
	}
	
})();
